import socket
import sys

def send_message(message, port):
    host = sys.argv[1]  # The server's hostname or IP address
    port = int(port)    # Convert port to an integer

    try:
        with socket.socket(socket.AF_INET, socket.SOCK_STREAM) as s:
            s.connect((host, port))
            s.sendall(message.encode())
            print(f"Sent: {message}")

            # Receive acknowledgment from the server
            data = s.recv(1024)
            print(f"Server reply: {data.decode()}")
    except ConnectionRefusedError:
        print(f"Could not connect to server at {host}:{port}")
    except Exception as e:
        print(f"An error occurred: {e}")

if __name__ == "__main__":
    if len(sys.argv) < 4:  # Updated to check for 4 arguments
        print("Usage: python client.py <host> <port> <message>")
    else:
        message = sys.argv[3]
        port = sys.argv[2]
        send_message(message, port)
